# BIOS 497/897 Spring, 2014
# By Chi Zhang
# 3/31/2014
# microaary analysis with limma package


library("affy")
library("limma")


setwd("/Users/chizhang/UNL/Teaching/BIOS879-2 Spring 2011/homeworks/GSE22479_RAW") #for Mac OS
#setwd("C:\\maize")  #for MS Windows


# deal with Cat100-6
targets = readTargets("Cat100-6_targets.txt")
dataab = ReadAffy(filenames=targets$FileName)
pdataab=rma(dataab)

design = cbind(CT=c(1,1,1,0,0,0),TR=c(0,0,0,1,1,1))
fit = lmFit(pdataab, design)
cont.matrix = makeContrasts(CTvsTR=CT-TR, levels=design)
fit2 = contrasts.fit(fit, cont.matrix)
fit2 = eBayes(fit2)

# get the significantly expressed genes [log(fold change)=1, FDR<0.00005]
results_Cat100_6 = topTable(fit2, number=30000, adjust.method="fdr", lfc=1)
top_results_Cat100_6[results_Cat100_6[,6]<0.00005,]
dim(top_results_Cat100_6)


# draw volcano plot
result_for_volcanoplot=topTable(fit2, number=30000, adjust.method="fdr", lfc=0)
lfc_Cat100_6 = result_for_volcanoplot[,2]
lpvalue_Cat100_6 = -log2(result_for_volcanoplot[,5])
plot(lfc_Cat100_6,lpvalue_Cat100_6, xlab="log(fold change)", ylab="-log(P values)")
#savePlot("volcano plots_Cat100", type="png")



# deal with S1587-17
targets = readTargets("S1587-17_targets.txt")
dataab = ReadAffy(filenames=targets$FileName)
pdataab=rma(dataab)

design = cbind(CT=c(1,1,1,0,0,0),TR=c(0,0,0,1,1,1))
fit = lmFit(pdataab, design)
cont.matrix = makeContrasts(CTvsTR=CT-TR, levels=design)
fit2 = contrasts.fit(fit, cont.matrix)
fit2 = eBayes(fit2)

# get the significantly expressed genes [log(fold change)=1, FDR<1]
results_S1587_17 = topTable(fit2, number=30000, adjust.method="fdr", lfc=1)
top_results_S1587_17=results_S1587_17[results_S1587_17[,6]<1,]
dim(top_results_S1587_17)


# draw volcano plot
result_for_volcanoplot=topTable(fit2, number=30000, adjust.method="fdr", lfc=0)
lfc_S1587_17 = result_for_volcanoplot[,2]
lpvalue_S1587_17 = -log2(result_for_volcanoplot[,5])
plot(lfc_S1587_17,lpvalue_S1587_17, xlab="log(fold change)", ylab="-log(P values)")
#savePlot("volcano plots_S1587_17", type="png")



# find the common probe id
intersect(top_results_Cat100_6$ID, top_results_S1587_17$ID)



